-- ui screen events

T_WEEK = Localize ("Week");
T_DAY = Localize ("Day");

function OnLoad ()
	CacheSound ("music/levelfailed.ogg");
	num_tips = DM_GetArraySize ("xml/tips.xml", "level_failed");

	
end;


function SetTip ()
	
	num_tips = DM_GetArraySize ("xml/tips.xml", "level_failed");
	Print ("Num tips: " ..num_tips .."\n");
	
	index = math.random (1, num_tips)-1;
	tip = DM_GetValue ("xml/tips.xml", "level_failed", index, "text");

	SetProperty ("text:label.text", tip);
end;



function OnEnter ()

	SetTip ();

     majorlevel = GetGameValue ("level_major");
    minorlevel = GetGameValue ("level_minor");
    
    SetProperty ("level_short_name:label.text", T_WEEK .. " " ..majorlevel.." / "..T_DAY.." "..minorlevel);
	-- get the required info to show here
	--SetProperty ("level_short_name:label.text", GetGameValue ("level_short_name"));
	SetProperty ("level_long_name:label.text", GetGameValue ("level_long_name"));
	--SetProperty("lives:label.text", GetGameValue("lives"))
	StopMusic (1.0); -- the parm is the fade out time
	PlaySound ("music/levelfailed.ogg");

	-- let's save the game state to worldmap so the player will resume there 
	-- if the window is closed now
	SaveGameState ("WorldMap");	
	
	if (Azkend_AutoplayerActive ()) then
		OnClick ("Replay");
	end;		
end;

function OnLeave ()
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
--	SetTip ();

	
	if (name == "Replay") then
		InitGameLevel ();
		SwitchScreen ("Game");
		return;
	end;
	if (name == "WorldMap") then
		SwitchScreen ("WorldMap");
		return;
	end;
	
end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 20);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));

end;

function OnDraw ()

end;
